<?php  

	include_once("Config/functions.php");	

	$nombreArchivo = $_FILES['archivoBanco']['name'];
	$destinoArchivo = $_SERVER['DOCUMENT_ROOT'] . "/sistemas/intranet/administrativo/cuotaspago/Files/Pagos/";
	$mensaje = "";

	date_default_timezone_set('America/Lima');
	$archivoFinal = $destinoArchivo . date("Ymd_hi") . "_" . $nombreArchivo;

	$subio = false;
	try {
		if ($_FILES['archivoBanco']['type'] == "text/plain") {
			if(move_uploaded_file($_FILES['archivoBanco']['tmp_name'], $archivoFinal)) {
				$mensaje = "Archivo subido correctamente!";
				$subio = true;
			}
		} 
		else {
			$mensaje = "La extensión del archivo debe ser \".txt \"";
		}
	} catch (Exception $e) {
		$mensaje = "Ocurrió un error al subir el archivo";
	}


	function procesaCuota($dni, $anno, $motivo,$pFechaPago,$pPension,$pMora,$pTotal){		
		$anno = substr($motivo,-4);
		$i = "false";
		$Query_Evaluation = "SELECT a.idalumno, codbanco, CONCAT(ape_pat,' ',ape_mat,', ', nombres) AS 'NOM', nro_cuota_int,nro_cuota_ban , motivo, fecha_pago, CASE idmodo WHEN 1 THEN 'SECR' WHEN 2 THEN 'BANC' WHEN 3 THEN 'DCTO' WHEN 4 THEN 'BECA' END  AS 'modopago', mora, a_cta, pension, estado
								FROM alumno a INNER JOIN cuotas_pago c ON a.idalumno=c.idalumno 
								WHERE a.dni='$dni' AND 
									 c.anno=$anno AND 
									 CONCAT(REPLACE(REPLACE(UPPER(c.motivo),'+',' '),'Ê','U'),' $anno')='$motivo';";
		//echo $Query_Evaluation;
		$rs = ExecuteDataSet($Query_Evaluation, "Busqueda Cuota Banco");
		$r = NULL;
		$result_err = "x";
		if($rs!=NULL){
			$bprocesa=false;
			if(mysql_num_rows($rs)==0){
				$result_err="Cuota no Encontrada";
			}elseif(mysql_num_rows($rs)>1){
				//vericamos que si hay mas de una cuota tenga solo una pendiente
				$cnt_pagados=0;
				while($r2 = mysql_fetch_array($rs)){
					if($r2["estado"]=="N"){
						$r = $r2;
						$cnt_pagados++;
					}
				}
				if($cnt_pagados==0) $result_err="Cuota con más de una coincidencia pero ya pagadas";
				elseif($cnt_pagados>1) $result_err="Cuota con más de una coincidencia";
				elseif($cnt_pagados==1) $bprocesa=true;
			}else{
				$r = mysql_fetch_array($rs);
				if($r["estado"]!="N") $result_err="Cuota ya está pagada";
				else $bprocesa=true;				
			}

			if($bprocesa){				
				$query_update = sprintf("UPDATE cuotas_pago set estado='S', idmodo=2, a_pagar=0, 
																fecha_pago='%s',dcto_add=(pension-%s), mora=%s, a_cta=%s 
										WHERE anno=%d AND idalumno='%s' AND nro_cuota_int=%d AND estado='N';",
										$pFechaPago,$pPension,$pMora,$pTotal,$anno,$r["idalumno"],$r["nro_cuota_int"]);
				$cnt_registros=ExecuteDataSet($query_update,"Actualizar Cuota",1);				
				$result_err = "";
			}
		}else{
			$result_err="Error en la consulta";
		}

		//$result = array('err'=>$result_err, 'result' => $r);
		return $result_err;
	}

	function generaFila($pDni,$pNombres,$pConcepto,$pFechaPago,$pMonto,$pMora,$pTotal,$error=""){
		if($error==""){
			$tr = sprintf("<tr><td>%s</td>
							   <td style='text-align:left;'>%s</td>
							   <td style='text-align:left;'>%s</td>
							   <td>%s</td>
							   <td style='text-align:right;'>%s</td>
							   <td style='text-align:right;'>%s</td>
							   <td style='text-align:right;'>%s</td></tr>",
						$pDni,$pNombres,$pConcepto,$pFechaPago,$pMonto,$pMora,$pTotal);
		}else{
			$tr = sprintf("<tr><td>%s</td>
							   <td style='text-align:left;'>%s</td>
							   <td style='text-align:left;'>%s</td>
							   <td>%s</td>
							   <td style='text-align:right;'>%s</td>
							   <td style='text-align:right;'>%s</td>
							   <td style='text-align:right;'>%s</td>
							   <td style='text-align:left;color:red;font-weight:bold;'>%s</td></tr>",
						$pDni,$pNombres,$pConcepto,$pFechaPago,$pMonto,$pMora,$pTotal,$error);
		}

		return $tr;
	}

	$tbl_ok = $tbl_err = "";
	if($subio){
		$tr_ok = $tr_err = ""	;		
		$BBVA=file($archivoFinal);
		if(is_array($BBVA)){
			for($x=0;$x<count($BBVA); $x++){
				$line = trim($BBVA[$x]); //get ilne text/plain
				if(strlen($line)>0){ //if exists line execute
					$ln_indicador = substr($line,0,2);
					if($ln_indicador=="02"){ //si es cuerpo del correo
						$ln_dni = substr($line,32,8);
						$ln_nombres = trim(substr($line,2,30));
						$ln_motivo = trim(substr($line,40,40));

						$ln_fechapago = substr($line,135,4)."-".substr($line,139,2)."-".substr($line,141,2);						
						$ln_pension = (substr($line,80,13)*1).".".substr($line,93,2);
						$ln_mora = (substr($line,110,13)*1).".".substr($line,123,2);
						$ln_total = (substr($line,95,13)*1).".".substr($line,108,2);
						
						$result_err = procesaCuota($ln_dni, 2018, $ln_motivo,$ln_fechapago,$ln_pension,$ln_mora,$ln_total);
						
						if($result_err==""){
							$tr_ok.=generaFila($ln_dni,$ln_nombres,$ln_motivo,$ln_fechapago,$ln_pension,$ln_mora,$ln_total);
						}else{
							$tr_err.=generaFila($ln_dni,$ln_nombres,$ln_motivo,$ln_fechapago,$ln_pension,$ln_mora,$ln_total,$result_err);
						}

						/*
						$mensaje.=$ln_dni.str_repeat("&nbsp;",10).$ln_motivo.str_repeat("&nbsp;",10).$ln_fechapago.str_repeat("&nbsp;",10).$ln_pension.str_repeat("&nbsp;",10).$ln_mora.str_repeat("&nbsp;",10).$ln_total.str_repeat("&nbsp;",10).procesaCuota($ln_dni, 2018, $ln_motivo,$ln_fechapago,$ln_pension,$ln_mora,$ln_total)."<br>";
						*/
					}
				}
			}
		}

		if($tr_ok!=""){
			$tbl_ok .= "<table class='linea f_string' style='width:80%'>";
			$tbl_ok .= "<caption style='text-align:left;font-size:13px;font-weight:bold;'>Registros cargados Correctamente</caption>";
			$tbl_ok .= "<tbody>";
			$tbl_ok .= "<tr class='cabecera'>";
			$tbl_ok .= "<td>DNI</td><td>Alumno</td><td>Concepto</td><td>Fecha Pago</td><td>Monto</td><td>Mora</td><td>Total</td>";
			$tbl_ok .= "</tr>";			
			$tbl_ok .= $tr_ok;
			$tbl_ok .= "</tbody>";
			$tbl_ok .= "</table>";
		}
		if($tr_err!=""){
			$tbl_err .= "<table class='linea f_string' style='width:100%'>";
			$tbl_err .= "<caption style='text-align:left;font-size:13px;font-weight:bold;'>Registros cargados con Error</caption>";
			$tbl_err .= "<tbody>";
			$tbl_err .= "<tr class='cabecera'>";
			$tbl_err .= "<td>DNI</td><td>Alumno</td><td>Concepto</td><td>Fecha Pago</td><td>Monto</td><td>Mora</td><td>Total</td><td>Error</td>";
			$tbl_err .= "</tr>";
			$tbl_err .= $tr_err;
			$tbl_err .= "</tbody>";
			$tbl_err .= "</table>";
		}
	}

	echo $tbl_ok."<br>".$tbl_err;

?>
