<?php date_default_timezone_set('America/Lima');

	include("conexion.php");
	include("details.php");

function SGAAD_EscribirLog($proceso,$usuario="",$exec=""){
	if($proceso=="*"){
		$texto  = str_repeat("*",150) . PHP_EOL;
	}else{
		$texto  = "Usuario/Fecha/Proceso: ".$usuario."/".date("Y-m-d H:i:s")."/".$proceso . PHP_EOL;
		$texto .= "Exec: ".$exec . PHP_EOL;
	}	
	$archivo = "Files/log/".date("Y_m_d_H").".dat";	
	$file = fopen($archivo, "a");
	fwrite($file, $texto);
	fclose($file);
}

#se obtiene el texto del tipo de proceso
function SGAAD_ObtenerTextoProceso($tipo){
	$desc = "Operacin";
	$tipo = $tipo."";
	if($tipo==cte_log_tipo_cambioFechaCuota)
		$desc = "Cambio de Fecha de Vcto";
	elseif($tipo==cte_log_tipo_cambioMoraCuota)
		$desc = "Cambio de Mora";
	elseif($tipo==cte_log_tipo_anulaDocumento)
		$desc = "Anula Documento";
			
	return $desc;
}

//retorna el monto de la mora
function SGAAD_ObtenerMontoMora($Y){
	$mora = 0;
	//para otros aos la mora es de 0.50
	switch($Y){
		case 2008: $mora = 0.3; break;
		case 2009: 
		case 2010:
		case 2011:
		case 2012: $mora = 0.7; break;
		default : $mora = 0.5;
	}

	return $mora;
}



//calcula el pronto pago
//calcula la mora	

function SGAAD_Calculate($monto_s, $calc_mora, $fecha_venc, $estado, $id, $data){

	$datos=explode("|",$data);
	$Y=$datos[0];
	
	$monto = $monto_s;
	$monto_mora = SGAAD_ObtenerMontoMora($Y);
	$dias   = resta_fechas(date("Y-m-d"), $fecha_venc);	
	if($id==1){
		if($calc_mora==1){
			if($dias>0){
				if($estado=='N'){
					$monto = $monto_mora*$dias;		
					if($monto>=30) $monto=30;
				}
			}	
		}
	}elseif($id==3){
		if($calc_mora==1){		
			$local=$datos[1];
			$dcto=$datos[2]*1;
	
			$arr=explode("-",$fecha_venc);
			$diaref=$arr[1]*1==6?"07":"07";
			$newfecha= sprintf("%s-%s-%s",$arr[0],$arr[1],$diaref);
			$dias   = resta_fechas(date("Y-m-d"),$newfecha);	
			#echo date("Y-m-d")."*****".$fecha_venc."*****".$dias."<br>";
			if($estado=='N'){ 
				if($dias<=0){					
					if($Y==2016){ $monto = 20; }
					elseif($Y==2017){
						#al RTBL no se aplica, y si tienen dscto no se aplica
						if($local!=4 && $local!=2){
							if($dcto==0){
								$monto=15;
							}
						}
					}
					elseif($Y>2017){
						#al RTBL no se aplica, y si tienen dscto no se aplica
						if($dcto==0){
							$monto=15;
						}
					}					
				}else{
					$monto=0;
				}	
			}				
		}		
	}
	
	return $monto;
}			



//Retorna la diferencia en dias de dos fechas



function resta_fechas($fecha1,$fecha2){           



	list($ao1,$mes1,$dia1)=split("-",$fecha1);



	list($ao2,$mes2,$dia2)=split("-",$fecha2);



    $dif = mktime(0,0,0,$mes1,$dia1,$ao1) - mktime(0,0,0,$mes2,$dia2,$ao2);



      $ndias=floor($dif/(24*60*60));



      return($ndias);



}



//Devuelve la cadena formateada de acuerdo al tipo de datos que este sea



function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "") 



{



  //$theValue = (!get_magic_quotes_gpc()) ? addslashes($theValue) : $theValue;







  switch ($theType) {



    case "text":



      $theValue = ($theValue != "") ? "'" . $theValue . "'" : "''";



      break;    



    case "long":



    case "int":



      $theValue = ($theValue != "") ? intval($theValue) : "NULL";



      break;



    case "double":



      $theValue = ($theValue != "") ? "'" . doubleval($theValue) . "'" : "NULL";



      break;



    case "date":



      $theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";



      break;



    case "defined":



      $theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;



      break;



  }



  return $theValue;



}







//Send a message err and print in the page 



$Img = "SheetStyles/Pictures/Fondo_SACO.gif";



$separator="txt_";



function ShowMessageErr($Msg, $Query, $Process) 



{



	$Err = "<font color=red>";



	$Err .= "<h1><u>Error</u></h1><br>";



	$Err .= "<h4>"."Proceso     : ".$Process;



	$Err .= "<br><br>";	



	$Err .= "Query       : ".$Query;



	$Err .= "<br><br>";		



	$Err .= "Descripcion : ".$Msg;



	$Err .= "</h4></font>";



	$Err .= "<blockquote><blockquote><blockquote><blockquote><blockquote>";



	$Err .= "<a href='#null' onclick=\"JavaScript:history.back();\"><b>volver al inicio</b></a>"; //location='filterdata.php'\



	$Err .= "</h3>";



	echo $Err;



}



//Show in Mode MSGBOX or ALERT
function ShowMessageModeMSGBOXandEXIT($URL, $Message="Not there is Message to Show"){
	$BuildingMSG  = "";
	$BuildingMSG .= "<script language=JavaScript>";
	$BuildingMSG .= "     alert('$Message');";
	$BuildingMSG .= "     window.location.href='$URL';";	
	$BuildingMSG .= "</script>";

	return $BuildingMSG;
}

function ShowMessageModeMSGBOXandOPEN($URL, $URLOPEN, $Message="Not there is Message to Show"){  
	$BuildingMSG  = ""; 
	$BuildingMSG .= "<script language=JavaScript>";
	$BuildingMSG .= "h = screen.height - 400;";
	$BuildingMSG .= "w = screen.width - 1300;";	
	$BuildingMSG .= "     window.open($URLOPEN,'_blank','width='+w+'px; height='+h+'px; top=50px; left=50px');";	
	//$BuildingMSG .= "     alert('$Message');";
	$BuildingMSG .= "     window.location.href='$URL';";	
	$BuildingMSG .= "</script>";
	return $BuildingMSG;
}



//Send Message To POP-UP and close windows upating to opener



function ShowMessageModeMSGBOXandEXITtoPOPUP($Message="Not there is Message to Show", $frm, $IfReload="true"){



	$BuildingMSG .= "<script language=JavaScript>";



	$BuildingMSG .= "     alert('$Message');";



	if($IfReload=="true"){		



		$BuildingMSG .= "     Obj=window.opener;";		



		$BuildingMSG .= "     Obj.document.all[\"$frm\"].submit();";			



	}



	$BuildingMSG .= "     window.close();";



	$BuildingMSG .= "</script>";



	return $BuildingMSG;



}



function sPrint($msgg){



	$msg="<h4><br>$msgg<br></h4>";



	return $msg;



}



//Rrturn a array with number interno and number bank



function ReturnNumberItemsFlow($idal, $anno, $mode){	
	$MySQL  = "SELECT MAX(nro_cuota_int) AS 'GET_VALUE' FROM cuotas_pago ";
	$MySQL .= "WHERE idalumno='$idal' AND anno=$anno";

	$nro_cuota_int = ExecuteScalar($MySQL, "Retorna Nro Interno");
	$nro_cuota_ban = "1000";

	$nro_cuota_int = $nro_cuota_int  + 1;
	if($mode==2){ //if is mode bank then extract to last
		$MySQL  = "SELECT MAX(nro_cuota_ban) AS 'GET_VALUE' FROM cuotas_pago ";
		$MySQL .= "WHERE idalumno='$idal' AND anno=$anno AND nro_cuota_ban<100";
		$nro_cuota_ban = ExecuteScalar($MySQL, "Retorna Nro Banco");
		$nro_cuota_ban = $nro_cuota_ban + 1;
	}

	$nros = array(
				"int"=>$nro_cuota_int,
				"ban"=>$nro_cuota_ban
			);

	return $nros;
}



//Excute a query SQL and return the state of the execute



function ExecuteNonQuery($MySQL, $Process){



	$User = $_SESSION['USUARIO']['idusuario'];



	$i = ExecuteDataSet($MySQL, $Process, 1);



	//RegisterProccess($User, "Registro la cuota NRO $nro_cuota_int de $idalumno en una operacion masiva"); 



	return $i;



}



//Return un RecordSet   *** available

/*
function ExecuteDataSeti($MySQL, $Process, $mode=0){
//	echo $MySQL;
	mysqli_select_db($GLOBALS["cniPagos"],$GLOBALS["database_cnPagos"]);
	$rs=mysqli_query($GLOBALS["cniPagos"],$MySQL) or die(ShowMessageErr(mysqli_error($GLOBALS["cniPagos"]),$MySQL, $Process));	
	$nm=mysqli_affected_rows($GLOBALS["cniPagos"]);

	if($mode==0){
		return $rs;
	}elseif($mode==1){
		return $nm;
	}
}
*/
function ExecuteDataSet($MySQL, $Process, $mode=0){



//	echo $MySQL;



	mysql_select_db($GLOBALS["database_cnPagos"]);



	$rs=mysql_query($MySQL, $GLOBALS["cnPagos"]) or die(ShowMessageErr(mysql_error(),$MySQL, $Process));	



	$nm=mysql_affected_rows();



	if($mode==0){



		return $rs;



	}elseif($mode==1){



		return $nm;



	}



}



//Retorna un valor escalar  *** available



function ExecuteScalar($MySQL, $Process){



	$rsValue =  (ExecuteDataSet($MySQL, $Process));



	if(mysql_num_rows($rsValue)>0){



		$Fila = mysql_fetch_assoc($rsValue);



		$OnlyValue = $Fila['GET_VALUE'];



	}



	else



		$OnlyValue = NULL;



	return $OnlyValue;



}



//Retorna una fecha formateada de modo yyyy-mm-dd  ***  not avalilable



function ReturnFormatDate($Fecha)



{



	$Fecha = "1996-02-11";



	$sFecha = "";







	$sFecha=date("/m/Y",$Fecha);



	return $sFecha;



}







//Retorna un numero entero formateado como por ejm. '0001'  ***  available



function ReturnFormatNumber($sNumber, $Zeros=3){



	if(strlen($sNumber)>$Zeros)



		return $sNumber;



	else{



		$sZeros=""; 



		for($x=0;$x<$Zeros;$x++)



			$sZeros = $sZeros."0";	



		$sNumber = $sZeros."".$sNumber;



		$Zeros = $Zeros*-1;



		$sNumber = substr($sNumber,$Zeros);



		return $sNumber; 		//return $sZeros;



	}



}



//Retorna una cadena sin slashes



function StringWithoutSlashes($cadena){



	$newcad="";



	for($i=0;$i<strlen($cadena);$i++){	



		$letra = $cadena[$i];



		if($letra!=trim("\ ")){



			$newcad=$newcad.$letra;



		}



	}



	return $newcad;



}



//Retorna la fecha de Hoy  en formato yyyy-mm-dd   *** available



function FechaHoy(){



	return date("Y-m-d");



}



//Llenamos un combo mediante un RecordSet



function FillControlList($rs, $NameCtrl, $ValueToSel, $IndexVal="", $IndexText="", $Event="", $TextAdd="", $css=""){	
	$sValues = "";
	if(strlen($IndexVal)==0) $IndexVal="VALUE_FIELD";
	if(strlen($IndexText)==0) $IndexText="TEXT_FIELD";
	//Agregamos Todos

	if($ValueToSel=="0") $sel="selected"; else $sel="";

	if($TextAdd=="")
		$sValues .="<option value=\"0\" $sel >[Todos]</option>\n";	
	elseif($TextAdd!="-")	
		$sValues .=sprintf("<option value=\"0\" $sel >%s</option>\n",$TextAdd);	

	while($Readrs = mysql_fetch_assoc($rs)){
		if($ValueToSel==$Readrs[$IndexVal]) $sel="selected"; else $sel="";
		$sValues .="<option value=\"".$Readrs[$IndexVal]."\" $sel>".$Readrs[$IndexText]."</option>\n";
	}

	$Event=is_numeric(strpos($Event,"="))?$Event:" onchange=\"$Event\"";
	if(mysql_num_rows($rs)>0)
		$WriteCbo="<select id=\"$NameCtrl\" name=\"$NameCtrl\"$Event>\n".$sValues."</select>";
	else
		$WriteCbo="<select id=\"$NameCtrl\" name=\"$NameCtrl\"$Event><option value=\"-\">------</option></select>";
	return $WriteCbo;
}



//Fill a COMBO having a array unidimensional where the key is the VALUE_FIELD 



function FillControlListToArray($ArrayBi, $NameCtrl, $ValueToSel, $Event=""){



	$sValues = "";



	foreach($ArrayBi as $VALUE=>$TEXT){



		if($ValueToSel==$VALUE) $sel="selected"; else $sel="";



		$sValues .="<option value=\"".$VALUE."\" $sel>".$TEXT."</option>\n";



	}



	if(count($ArrayBi)>0)



		$WriteCbo="<select id=\"$NameCtrl\" name=\"$NameCtrl\" onchange=\"$Event\">\n".$sValues."</select>";



	else



		$WriteCbo="<select id=\"$NameCtrl\" name=\"$NameCtrl\" onchange=\"$Event\">\n<option value=\"-\">------</option>\n</select>";







	return $WriteCbo;	



}



/*



	FUNCIONES QUE USAN LAS FUNCIONES DECRITAS ANTERIOR A ESTAS LINEAS 



	LLAMADAS TAMBIEN FUNCIONES DERIVADAS



*/



/*







*/



//Return Code for print to list of locals



function ListaLocal($value, $addEvent="",$TextAdd=""){
	$dsLocal = ExecuteDataSet("SELECT idlocal as VALUE_FIELD, deslocal as TEXT_FIELD FROM local_ ORDER BY VALUE_FIELD DESC", "Lista de Locales"); 
	$strctrl = FillControlList($dsLocal, "txt_idlocal", $value, "", "", $addEvent,$TextAdd);
	return $strctrl;
}
function ListaParametroGeneral($tipo,$ctrlId,$value,$textAdd="-",$addEvent=""){
/*	$arrayLocal = array('','AREQUIPA', 'MONTESSORI', 'LINCE', 'SALAVERRY' ,'CALCA' ,'ROSALES' ,'ARANCIBIA' ,'BELISARIO' ,'MANUEL DEL PINO' ,'6 DE AGOSTO' ,'AGOSTITO' ,'CASONA' ,'MAXIMILIANO' ,'CASTILLA' ,'MOQUEGUA' ,'TAMBO' ,'SAN LUIS' ,'BERTONELLY' ,'BARRANCO' ,'ARENALES' ,'MAXIMILIANO' ,'CASTILLA II' ,'AYACUHO' ,'LUCERO' ,'CALLAO' ,'SALAMANCA','AGUSTINO' ,'LA VICTORIA');
	$strctrl=FillControlListToArray($arrayLocal,"txt_idlocal",$value,$addEvent);		*/
	$ds = ExecuteDataSet("SELECT nid_documento as VALUE_FIELD, no_documento as TEXT_FIELD 
							   FROM documentos
							   WHERE co_tipo_documento='$tipo'
							   ORDER BY TEXT_FIELD ASC", "Lista de Parametros"); 
	$strctrl = FillControlList($ds, $ctrlId, $value, "", "", $addEvent,$textAdd);
	return $strctrl;
}


//Follow the register a proccess make to user
function RegisterProccess($User, $Proc, $pTipo=0){
	$Fecha = FechaHoy();
	$Hora  = date("h:m:s");
	$MySQL  = "INSERT INTO `procesos` (`idusuario` , `desproceso` , `tipo` , `fecha` , `estado`, `hora_p` ) ";
	$MySQL .= "VALUES ('$User', '$Proc', $pTipo, '$Fecha', 'P', '$Hora');";

	ExecuteNonQuery($MySQL, "No se Registro el Proceso");
}

//Sen Message where exists pay in table
function EvaluaPago($idal, $cod_banco, $anno, $nro_i,$estado=""){
/*	$sDELETEPay = "DELETE FROM pago WHERE codbanco='$cod_banco' AND nro_cuota_int=$nro_i";
	ExecuteNonQuery($sDELETEPay, "Elimina una Cuota ... ");
	if($estado=="S"){//Inserta el Pago siempre y cuando sea cancelado sino solo lo elimina
		$sINSERTPay  = "INSERT INTO `pago` (`codbanco`, `nro_cuota_int` , `nro_cuota_ban` , `motivo` , `fecha_venc` , `fecha_pago` , `monto` , `dcto` , `pension` , `mora` , `a_pagar` , `a_cta` , `estado` , `idmodo` , `idusuario`)  SELECT '$cod_banco', `nro_cuota_int` , `nro_cuota_ban` , `motivo` , `fecha_venc` , `fecha_pago` , `monto` , `dcto` , `pension` , `mora` , `a_pagar` , `a_cta` , `estado` , `idmodo` , `idusuario`  FROM cuotas_pago  WHERE idalumno='$idal' AND anno=$anno AND nro_cuota_int=$nro_i";		
		ExecuteNonQuery($sINSERTPay, "Inserta una Cuota ... ");	
	}*/
}

#UPGRADE MODULO - FICHA DE MATRICULA
/*JAVASCRIPT*/
function Js_Alert($pMessage){
	return sprintf("<script language=\"JavaScript\">alert('%s');</script>",$pMessage);
}

/*CONSTANTES*/
function Val_Fecha($pFecha){
	$val=false; /* yyyy-mm-dd */
	$year = substr($pFecha,0,4);
	$month = substr($pFecha,5,2);
	$day = substr($pFecha,8,2);

	switch($month){
		case 1: case 3: case 5: case 7: case 8: case 10: case 12:
			$val=($day>=1 && $day<=31);;
			break;
		case 2: case 4: case 6: case 9: case 11:
			if($month==2)
				if($year%4==0)
					$val = ($day>=1 && $day<=29);
				else
					$val = ($day>=1 && $day<=28);
			else
				$val = ($day>=1 && $day<=30);
			break;
	}

	return $val;
}

function Txt_FechaVenc($pAnio,$pNumMes,$pDia){
	//$pDia=($pNumMes>=12?16:1);
	$pNumMes=$pNumMes*1;
	//$pNumMes=($pNumMes>=12?12:$pNumMes+1);

	switch($pNumMes){
		case 3: case 5: case 7: case 8: case 10:
			$pDia=31;
			break;

		case 4: case 6:	case 9: case 11:
			$pDia=30;
			break;			

		case 12:
			$pDia=($pAnio>2017?31:16);
			break;
	}	

	$vl_fecha=sprintf('%d-%d-%d',$pAnio,$pNumMes,$pDia);
	//if(Val_Fecha($pFecha))
	/*
	Verificar q es fecha
	Si es domingo o feriado aumentarle un dia
	Si no es fecha aumentarle un dia
	Si el aumentado se pasa del mes restarle hasta el maximo dia habil	
	*/

	return $vl_fecha;
}



function Txt_Motivo($pNumMes){



	$arr = array("3"=>"P. Marzo","4"=>"P. Abril","5"=>"P. Mayo",



				 "6"=>"P. Junio","7"=>"P. Julio","8"=>"P. Agosto",



				 "9"=>"P. Setiembre","10"=>"P. Octubre","11"=>"P. Noviembre","12"=>"P. Diciembre");



	foreach($arr as $k=>$v){



		if($k==$pNumMes)



			return $v;



	}



	return "";



}



function Txt_SiNo($pCod){



	$txt="";



	if($pCod=="S") $txt="SI";



	elseif($pCod=="N") $txt="NO";	



	return $txt;



}



function Txt_Sexo($pSexo){



	$txt="";



	if($pSexo=="F") $txt="Femenino";



	elseif($pSexo=="M") $txt="Masculino";	



	return $txt;



}



function Txt_Turno($pSexo){



	$txt="";



	if($pSexo=="M") $txt="Maana";



	elseif($pSexo=="T") $txt="Tarde";	



	elseif($pSexo=="N") $txt="Noche";		



	return $txt;



}



function Txt_TipoColegio($pCoTipo){



	$txt="";



	if($pCoTipo=="P") $txt="Particular";



	elseif($pCoTipo=="E") $txt="Estatal";	



	return $txt;



}



/*CONTROLES*/



function Ctrl_Cbo($pClientID, $pValue, $pStyle, $rs, $pJs=""){



	$cbo  = "<select id=\"$pClientID\" name=\"$pClientID\" style=\"$pStyle\" $pJs>";



	while($r=mysql_fetch_array($rs)){



		$sel = "";



		if($r[0]==$pValue) 



			$sel="selected";



		$cbo .= "<option value=\"".$r[0]."\" $sel>".$r[1]."</option>";		



	}



	$cbo .= "</select>";



	return $cbo;



}



function Ctrl_SiNo($pClientID, $pValue, $pStyle){ 



	$arr = array(""=>"Sel", "S"=>"SI","N"=>"NO");



	$cbo  = "<select id=\"$pClientID\" name=\"$pClientID\" style=\"$pStyle\">";



	foreach($arr as $k=>$v){



		$sel = "";



		if($k==$pValue) $sel="selected";



		$cbo .= "<option value=\"$k\" $sel>$v</option>";



	}



	$cbo .= "</select>";



	return $cbo;



}	



function Ctrl_Sexo($pClientID, $pValue, $pStyle){ 



	$arr = array(""=>"Seleccione", "M"=>"Masculino","F"=>"Femenino");



	$cbo  = "<select id=\"$pClientID\" name=\"$pClientID\" style=\"$pStyle\">";



	foreach($arr as $k=>$v){



		$sel = "";



		if($k==$pValue) $sel="selected";



		$cbo .= "<option value=\"$k\" $sel>$v</option>";



	}



	$cbo .= "</select>";



	return $cbo;



}	



function Ctrl_ModoPago($pClientID, $pValue, $pStyle){ 



	$arr = array(""=>"Seleccione", "1"=>"Secretaria", "2"=>"Banco","3"=>"Dcto Planilla");



	$cbo  = "<select id=\"$pClientID\" name=\"$pClientID\" style=\"$pStyle\">";



	foreach($arr as $k=>$v){



		$sel = "";



		if($k==$pValue) $sel="selected";



		$cbo .= "<option value=\"$k\" $sel>$v</option>";



	}



	$cbo .= "</select>";



	return $cbo;



}	



function Ctrl_Turno($pClientID, $pValue, $pStyle){ 



	$arr = array("M"=>"Ma&ntilde;ana");/*,"T"=>"Tarde"*/



	$cbo  = "<select id=\"$pClientID\" name=\"$pClientID\" style=\"$pStyle\">";



	foreach($arr as $k=>$v){



		$cbo .= "<option value=\"$k\">$v</option>";



	}



	$cbo .= "</select>";



	return $cbo;



}	



function Ctrl_CboAnio($pClientID, $pValue, $pStyle, $fini, $ffin){ 



	$cbo  = "<select id=\"$pClientID\" name=\"$pClientID\" style=\"$pStyle\">";



	for($i=$fini;$i<=$ffin;$i++){



		$sel = "";



		if($i==$pValue) 



			$sel="selected";



		$cbo .= "<option value=\"$i\" $sel>$i</option>";	



	}



	$cbo .= "</select>";



	return $cbo;



}	



function Ctrl_CboMes($pClientID,$pValue,$pStyle){



	$arr = array("1"=>"Enero","2"=>"Febrero","3"=>"Marzo","4"=>"Abril",



				"5"=>"Mayo","6"=>"Junio","7"=>"Juio","8"=>"Agosto",



				"9"=>"Setiembre","10"=>"Octubre","11"=>"Noviembre","12"=>"Diciembre");



	$cbo  = "<select id=\"$pClientID\" name=\"$pClientID\" style=\"$pStyle\">";



	foreach($arr as $k=>$v){



		$sel = "";



		if($k==$pValue) 



			$sel="selected";



		$cbo .= "<option value=\"$k\" $sel>$v</option>";		



	}



	$cbo .= "</select>";



	return $cbo;



}



function Ctrl_TxtFecha($pClientID, $pValue, $pMostrar=true){



	$txt="<input id=\"$pClientID\" name=\"$pClientID\" type=\"text\" value=\"$pValue\" readonly style=\"width:120px\">";

	

	if($pMostrar)

	$txt.="<a href=\"#null\"><img src=\"SheetStyles/Pictures/calendario/i.p.calendario.gif\" onClick=\"popUpCalendar(this,$pClientID,'yyyy-mm-dd');\" 		  

		  					border=\"0\" alt=\"Seleccionar Fecha\" align=\"top\">";

	$txt.="</a>";

							

	return $txt;



}



function Ctrl_CboNivel($pClientID,$pStyle){



	$arr = array("1"=>"Inicial","2"=>"Primaria","3"=>"Secundaria");



	$cbo  = "<select id=\"$pClientID\" name=\"$pClientID\" style=\"$pStyle\">";



	foreach($arr as $k=>$v){



		$cbo .= "<option value=\"$k\">$v</option>";



	}



	$cbo .= "</select>";



	return $cbo;



}



/*Formatea la cadena para una sentencia SQL*/



function GetSQLValue($value, $type="0"){



	switch($type){



		case 0: //Cadena



			$value=(($value!="")?("'".$value."'"):"NULL");		



			break;



		case 1: //Numero



			$value=(($value!="")?$value:"NULL");



			break;



	}	



	return $value;



}


function fn_enviar_sunat($codigo,$tipoOpe,$tipoDoc,$tipoDet){ 
	#########################################################
	#### INTEGRACIN FCIL ####
	#+++++++++++++++++++++++++++++++++++++++++++++++++++++++
	# ESTE CDIGO FUNCIONA PARA LA VERSIN ONLINE Y OFFLINE
	# Visita www.nubefact.com/integracion para ms informacin
	#+++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	#########################################################
	#### FORMA DE TRABAJO ####
	#+++++++++++++++++++++++++++++++++++++++++++++++++++++++
	# PASO 1: Conseguir una RUTA y un TOKEN para trabajar con NUBEFACT (Regstrate o ingresa a tu cuenta en www.nubefact.com).
	# PASO 2: Generar un archivo en formato .JSON o .TXT con una estructura que se detalla en este documento.
	# PASO 3: Enviar el archivo generado a nuestra WEB SERVICE ONLINE u OFFLINE segn corresponda usando la RUTA y el TOKEN.
	# PASO 4: Generamos el archivo XML y PDF (Segn especificaciones de la SUNAT) y te devolveremos INSTANTNEAMENTE los datos del documento generado.
	# Para ver el documento generado ingresa a www.nubefact.com/login con tus datos de acceso, y luego a la opcin "Ver Facturas, Boletas y Notas"
	# IMPORTANTE: Enviaremos el XML generado a la SUNAT y lo almacenaremos junto con el PDF, XML y CDR en la NUBE para que tu cliente pueda consultarlo en cualquier momento, si as lo desea.
	#+++++++++++++++++++++++++++++++++++++++++++++++++++++++

	#########################################################
	#### PASO 1: CONSEGUIR LA RUTA Y TOKEN ####
	#+++++++++++++++++++++++++++++++++++++++++++++++++++++++
	# - Regstrate gratis en www.nubefact.com/register
	# - Ir la opcin API (Integracin).
	# IMPORTANTE: Para que la opcin API est activada necesitas escribirnos a soporte@nubefact.com o llmanos al telfono: 01 468 3535 (opcin 2) o celular (WhatsApp) 955 598762.
	#+++++++++++++++++++++++++++++++++++++++++++++++++++++++
	 
	
	//$token ="ab63079e-55d8-4f67-9a52-44f4875ceb6d-0abb56bc-c400-4325-8c17-3ebe7e0c70e3";
	#########################################################
	#### PASO 2: GENERAR EL ARCHIVO PARA ENVIAR A NUBEFACT ####
	#+++++++++++++++++++++++++++++++++++++++++++++++++++++++
	# - MANUAL para archivo JSON en el link: https://goo.gl/WHMmSb
	# - MANUAL para archivo TXT en el link: https://goo.gl/Lz7hAq
	#+++++++++++++++++++++++++++++++++++++++++++++++++++++++
	$query="";
	if($tipoDoc=="PEN"){
		$query=" c.EstCod='004' ";
	}elseif($tipoDoc=="BAN"){
		$query=" d.nid_documento in (". $SCmpCod.")";
	}else{
		$query="  d.nid_documento=".$codigo;  
	}
	/*
	$notC="select c.CmpCod,d.co_tipo_documento_sunat as tipo_de_comprobante,c.NumSer,c.NumDoc,(case when c.CmpTip=20 or c.CmpTip=25 or c.CmpTip=34 THEN 1 ELSE 6 END) AS cliente_tipo_de_documento";
  	$notC.=",IFNULL(NumRuc,NroDoc) as cliente_numero_de_documento ,IFNULL(NomCom,CONCAT(EntNom,' ',ApePat,' ',ApeMat)) AS cliente_denominacion,EntDir as cliente_direccion";
 	$notC.=",NULL as cliente_email,NULL as cliente_email_1,NULL as cliente_email_2,c.FehEmi as fecha_de_emision,c.FehVct as fecha_de_vencimiento,c.MonCod as moneda,NULL as tipo_de_cambio";
 	$notC.=",(p.Atr003*100) as porcentaje_de_igv,NULL as descuento_global,NULL as total_descuento,NULL as total_anticipo";
	$notC.=",(c.MntTot- round(c.MntTot-((c.MntTot/(1+p.Atr003))),2) ) as total_gravada,c.MntTot as total_inafecta,NULL as total_exonerada";
	$notC.=",round(c.MntTot-((c.MntTot/(1+p.Atr003))),2) as total_igv,NULL as total_gratuita,NULL as total_otros_cargos,c.MntTot as total,NULL as percepcion_tipo";
	$notC.=",NULL as percepcion_base_imponible,c.MntPcp  as total_percepcion,c.MntPcp as total_incluido_percepcion,c.CmpObs AS observaciones";
	$notC.=",cref.co_tipo_documento_sunat as documento_que_se_modifica_tipo,cref.NumSer as documento_que_se_modifica_serie,cref.NumDoc as documento_que_se_modifica_numero";
	$notC.=",(case when d.nid_documento=25 then c.TipNcr else '' end) as tipo_de_nota_de_credito,(case when d.nid_documento=34 then 1 else '' end) as tipo_de_nota_de_debito ";
	$notC.=",c.CmpObsElim,ca.CjaUrl,ca.CjaTok  ";
	$notC.="from CmpTab".$tbl." c ";
	$notC.="INNER JOIN mae_documento d on d.nid_documento=c.CmpTip ";
	$notC.="INNER JOIN EntTab e on c.EntCod=e.EntCod ";
	$notC.="INNER JOIN CjaTab ca on ca.SucCod=c.SucCod and ca.FlgAct=1 ";
	$notC.="CROSS JOIN (select Atr003 from PrmTab WHERE GrpCod=48 and PrmVal='01') p ";
	$notC.="LEFT JOIN (select *from CmpTab".$tbl." cc INNER JOIN mae_documento dd on dd.nid_documento=cc.CmpTip) cref on cref.CmpCod=c.CmpRef ";
	 */
	 $notC="select d.nid_documento as CmpCod,doc.co_tipo_documento_sunat as tipo_de_comprobante,d.nu_serie as NumSer,d.nu_documento as NumDoc,(case when (d.co_tipo=1 or d.co_tipo=42) THEN 1 ELSE 6 END) AS cliente_tipo_de_documento";
  	$notC.=",IFNULL(a.dni,0) as cliente_numero_de_documento ,CONCAT(a.ape_pat,' ',a.ape_mat,' ',a.nombres)  AS cliente_denominacion,NULL as cliente_direccion";
 	$notC.=",NULL as cliente_email,NULL as cliente_email_1,NULL as cliente_email_2,d.fe_documento as fecha_de_emision,NULL as fecha_de_vencimiento,1 as moneda,NULL as tipo_de_cambio";
 	$notC.=",(0.18*100) as porcentaje_de_igv,NULL as descuento_global,NULL as total_descuento,NULL as total_anticipo";
	$notC.=",NULL as total_gravada,d.mt_documento as total_inafecta,NULL as total_exonerada";
	$notC.=",NULL as total_igv,NULL as total_gratuita,NULL as total_otros_cargos,d.mt_documento as total,NULL as percepcion_tipo";
	$notC.=",NULL as percepcion_base_imponible,NULL  as total_percepcion,NULL as total_incluido_percepcion,d.tx_glosa AS observaciones";
					 
	$notC.=",cref.co_tipo_documento_sunat as documento_que_se_modifica_tipo,cref.nu_serie as documento_que_se_modifica_serie,cref.nu_documento as documento_que_se_modifica_numero";
	$notC.=",NULL as tipo_de_nota_de_credito,(case when d.co_tipo=42 then 1 else '' end) as tipo_de_nota_de_debito";
	$notC.=",d.obsElim as CmpObsElim,IFNULL(artcod,0) as artcod,l.urlsunat as CjaUrl,l.tokensunat as CjaTok,IFNULL(d.docref,0) as docref,d.co_estado ";
	$notC.="from documento_venta  d ";
	$notC.="INNER JOIN documentos doc on d.co_tipo=doc.nid_documento ";
	$notC.="INNER JOIN alumno a on d.idalumno=a.idalumno ";
	$notC.="LEFT JOIN ficha_matricula f on f.idalumno=a.idalumno and f.anno=(select max(anno) from ficha_matricula  fd where fd.idalumno=f.idalumno) ";
	$notC.="INNER JOIN local_ l on d.nid_local=l.idlocal ";
	$notC.="LEFT JOIN (select cc.nid_documento,co_tipo_documento_sunat,nu_serie,nu_documento from documento_venta cc  INNER JOIN documentos dd on dd.nid_documento=cc.co_tipo) cref ";
	$notC.="on cref.nid_documento=d.docref  ";
	$notC.="WHERE 0=0 and ".$query;  
	$nc=ExecuteDataSet($notC,"Lista de Documentos Pendientes");
	 
	$datosCabecera = array();
	$total_igv=0;$total_gravada=$total_inafecta=0;
	while($rc=mysql_fetch_assoc($nc)){
		//if($tipoDet=="PEN"){
		if($rc["artcod"]*1==0){	
			$campo=($rc["co_estado"]=="03")	?"c.a_pagar":"c.a_cta";
			//if($rc["docref"]==0){
				$notx="select 'ZZ'  as unidad_de_medida,NULL as codigo,'86120000' as codigo_producto_sunat,c.motivo as descripcion";
				$notx.=",1 CntAte,".$campo." as valor_unitario,".$campo." as ArtPre,".$campo." as CstTot";
				$notx.=",(CASE 0 WHEN 1 THEN 1 WHEN 0 THEN 9 END) as tipo_de_igv,0 as igv ";
				$notx.="from cuotas_pago c ";
				$notx.="where c.nid_documento_venta=".$rc["CmpCod"];  
			/*}else{
				$notx="select 'ZZ'  as unidad_de_medida,NULL as codigo,'86120000' as codigo_producto_sunat,'REGULARIZACIN DE PENSIN' as descripcion";
				$notx.=",1 CntAte,c.mora as valor_unitario,c.mora as ArtPre,c.mora as CstTot";
				$notx.=",(CASE 0 WHEN 1 THEN 1 WHEN 0 THEN 9 END) as tipo_de_igv,0 as igv ";
				$notx.="from cuotas_pago c ";
				$notx.="where c.nid_documento_venta=".$rc["docref"]; //echo $notx;
			}*/
//		}else if($tipoDet=="VTA"){
		}else if($rc["artcod"]*1>0){	
			$notx="select 'ZZ'  as unidad_de_medida,NULL as codigo,a.artcodsun as codigo_producto_sunat,a.artdsc as descripcion";
			$notx.=",1 CntAte,d.mt_documento as valor_unitario,d.mt_documento as ArtPre,d.mt_documento as CstTot";
			$notx.=",(CASE 0 WHEN 1 THEN 1 WHEN 0 THEN 9 END) as tipo_de_igv,0 as igv  ";
			$notx.="from documento_venta d ";
			$notx.="INNER JOIN articulo a on a.artcod=d.artcod ";
			$notx.="where d.nid_documento=".$rc["CmpCod"]; //echo $notx;
		}	

		$n=ExecuteDataSet($notx,"Lista de Documentos Detalle Pendientes");
		$datosDetalle = array(); 
		 
		while($r=mysql_fetch_assoc($n)){
			$total_igv=($r["tipo_de_igv"]==1)?$rc["total_igv"]:0;
			if($r["tipo_de_igv"]==1){
				$total_gravada=$rc["total_gravada"];
			}else if($r["tipo_de_igv"]==9){
				$total_inafecta=$rc["total_inafecta"];
			}
			if($tipoOpe*1==1){	
				$motivo=(strpos($r['descripcion'], "+") === false)?$r['descripcion']:substr($r['descripcion'],0,strpos($r['descripcion'], "+"));
				$detalle["unidad_de_medida"]=$r["unidad_de_medida"];
				$detalle["codigo"]="";
				$detalle["codigo_producto_sunat"]=$r["codigo_producto_sunat"];
				$detalle["descripcion"]=utf8_encode($motivo);//utf8_encode($r["descripcion"]);
				$detalle["cantidad"]=$r["CntAte"];
				$detalle["valor_unitario"]=$r["valor_unitario"];
				$detalle["precio_unitario"]=$r["ArtPre"];
				$detalle["descuento"]=0;
				$detalle["subtotal"]=$r["valor_unitario"]*$r["CntAte"];
				$detalle["tipo_de_igv"]=$r["tipo_de_igv"];
				$detalle["igv"]=$r["igv"];
				$detalle["total"]=$r["CstTot"];
				$detalle["anticipo_regularizacion"]="false";
				$detalle["anticipo_documento_serie"]="";
				$detalle["anticipo_documento_numero"]=""; 
				$datosDetalle[] =$detalle;
			}
		}
		
		if($tipoOpe*1==1){//grabar
			$datosCabecera["operacion"]="generar_comprobante";
			$datosCabecera["tipo_de_comprobante"]=$rc["tipo_de_comprobante"];
			$datosCabecera["serie"]=$rc["NumSer"];
			$datosCabecera["numero"]=$rc["NumDoc"];
			$datosCabecera["sunat_transaction"]=1;
			$datosCabecera["cliente_tipo_de_documento"]=$rc["cliente_tipo_de_documento"];
			$datosCabecera["cliente_numero_de_documento"]=$rc["cliente_numero_de_documento"];
			$datosCabecera["cliente_denominacion"]=utf8_encode($rc["cliente_denominacion"]);
			$datosCabecera["cliente_direccion"]=$rc["cliente_direccion"];
			$datosCabecera["cliente_email"]=$rc["cliente_email"];
			$datosCabecera["cliente_email_1"]=$rc["cliente_email_1"];
			$datosCabecera["cliente_email_2"]=$rc["cliente_email_2"];
			$datosCabecera["fecha_de_emision"]=$rc["fecha_de_emision"];
			$datosCabecera["fecha_de_vencimiento"]=$rc["fecha_de_vencimiento"];
			$datosCabecera["moneda"]=$rc["moneda"];
			$datosCabecera["tipo_de_cambio"]=$rc["tipo_de_cambio"];
			$datosCabecera["porcentaje_de_igv"]=$rc["porcentaje_de_igv"];
			$datosCabecera["descuento_global"]=$rc["descuento_global"];
			$datosCabecera["descuento_global"]=$rc["descuento_global"];
			$datosCabecera["total_descuento"]=$rc["total_descuento"];
			$datosCabecera["total_anticipo"]=$rc["total_anticipo"];
			$datosCabecera["total_gravada"]=$total_gravada;//$rc["total_gravada"]; 
			$datosCabecera["total_inafecta"]=$total_inafecta;
			$datosCabecera["total_exonerada"]=$rc["total_exonerada"];
			$datosCabecera["total_igv"]=$total_igv;//$rc["total_igv"];
			$datosCabecera["total_gratuita"]=$rc["total_gratuita"];
			$datosCabecera["total_otros_cargos"]=$rc["total_otros_cargos"];
			$datosCabecera["total"]=$rc["total"];
			$datosCabecera["percepcion_tipo"]=$rc["percepcion_tipo"];
			$datosCabecera["percepcion_base_imponible"]=$rc["percepcion_base_imponible"];
			$datosCabecera["total_percepcion"]=$rc["total_percepcion"];
			$datosCabecera["total_incluido_percepcion"]=$rc["total_incluido_percepcion"];
			$datosCabecera["detraccion"]= "false";
			$datosCabecera["observaciones"]=$rc["observaciones"];
			$datosCabecera["documento_que_se_modifica_tipo"]=$rc["documento_que_se_modifica_tipo"];
			$datosCabecera["documento_que_se_modifica_serie"]=$rc["documento_que_se_modifica_serie"];
			$datosCabecera["documento_que_se_modifica_numero"]=$rc["documento_que_se_modifica_numero"];
			$datosCabecera["tipo_de_nota_de_credito"]=$rc["tipo_de_nota_de_credito"];
			$datosCabecera["tipo_de_nota_de_debito"]=$rc["tipo_de_nota_de_debito"]; 
			$datosCabecera["enviar_automaticamente_a_la_sunat"]= "true";
			$datosCabecera["enviar_automaticamente_al_cliente"]="false";
			$datosCabecera["codigo_unico"]="";
			$datosCabecera["condiciones_de_pago"]="";
			$datosCabecera["medio_de_pago"]="";
			$datosCabecera["placa_vehiculo"]="";
			$datosCabecera["orden_compra_servicio"]="";
			$datosCabecera["tabla_personalizada_codigo"]="";
			$datosCabecera["formato_de_pdf"]="TICKET";
			$datosCabecera["items"]= $datosDetalle;
		}else if($tipoOpe*1==2){//anular
			$datosCabecera["operacion"]="generar_anulacion";
			$datosCabecera["tipo_de_comprobante"]=$rc["tipo_de_comprobante"];
			$datosCabecera["serie"]=$rc["NumSer"];
			$datosCabecera["numero"]=$rc["NumDoc"];
			$datosCabecera["motivo"]=$rc['CmpObsElim'];
			$datosCabecera["codigo_unico"]="";
		}
		
		// RUTA para enviar documentos
		$ruta = trim($rc['CjaUrl']);
		//TOKEN para enviar documentos
		$token =trim($rc['CjaTok']);
	
	}
 
	/* 
  	echo "<pre>";
print_r($datosCabecera);
echo "</pre>";  
 */
  
	
 	$data_json = json_encode($datosCabecera);
	//Invocamos el servicio de NUBEFACT
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $ruta);
	curl_setopt(
		$ch, CURLOPT_HTTPHEADER, array(
		'Authorization: Token token="'.$token.'"',
		'Content-Type: application/json',
		)
	);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
	curl_setopt($ch, CURLOPT_POSTFIELDS,$data_json);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	$respuesta  = curl_exec($ch);
	curl_close($ch);  
	 
	/*
	 #########################################################
	#### PASO 4: LEER RESPUESTA DE NUBEFACT ####
	+++++++++++++++++++++++++++++++++++++++++++++++++++++++
	# Recibirs una respuesta de NUBEFACT inmediatamente lo cual se debe leer, verificando que no haya errores.
	# Debes guardar en la base de datos la respuesta que te devolveremos.
	# Escrbenos a soporte@nubefact.com o llmanos al telfono: 01 468 3535 (opcin 2) o celular (WhatsApp) 955 598762
	# Puedes imprimir el PDF que nosotros generamos como tambin generar tu propia representacin impresa previa coordinacin con nosotros.
	# La impresin del documento seguir hacindose desde tu sistema. Enviaremos el documento por email a tu cliente si as lo indicas en el archivo JSON o TXT.
	+++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	 */
	$rpt="";
	$leer_respuesta = json_decode($respuesta, true);
 	/*   echo "<pre>";
	 print_r($leer_respuesta );
	 echo "</pre>"; */ 
	if (isset($leer_respuesta['errors'])) {
		//Mostramos los errores si los hay
		$rpt="0$$".$leer_respuesta['errors'];
 
	} else {
		//Mostramos la respuesta
		if($tipoOpe*1==1){//grabar
			$rpt =$leer_respuesta['tipo_de_comprobante']."$".$leer_respuesta['serie']."$".$leer_respuesta['numero']."$".$leer_respuesta['enlace']."$".$leer_respuesta['aceptada_por_sunat']."$"; 
			$rpt.=$leer_respuesta['sunat_description']."$". $leer_respuesta['sunat_note']."$".$leer_respuesta['sunat_responsecode']."$". $leer_respuesta['sunat_soap_error']."$"; 
			$rpt.=$leer_respuesta['pdf_zip_base64']."$".$leer_respuesta['xml_zip_base64']."$".$leer_respuesta['cdr_zip_base64']."$".$leer_respuesta['cadena_para_codigo_qr']."$"; 
			$rpt.=$leer_respuesta['codigo_hash']; 
			$rpt=$leer_respuesta['enlace'].".pdf@@".$leer_respuesta['key'].".pdf";//@@".$leer_respuesta['tipo_de_comprobante']."_".$leer_respuesta['serie']."_".$leer_respuesta['numero'];
		}else if($tipoOpe*1==2){//anular
			$rpt =$leer_respuesta['numero']."$".$leer_respuesta['sunat_ticket_numero']."$".$leer_respuesta['aceptada_por_sunat']."$".$leer_respuesta['sunat_description']."$".$leer_respuesta['sunat_note']."$"; 
			$rpt.=$leer_respuesta['sunat_responsecode']."$". $leer_respuesta['sunat_soap_error']."$".$leer_respuesta['xml_zip_base64']."$". $leer_respuesta['pdf_zip_base64']."$".$leer_respuesta['cdr_zip_base64']."$"; 
			 
			$rpt=$leer_respuesta['enlace'].".pdf@@".$leer_respuesta['key'].".pdf";//@@".$leer_respuesta['numero'];
		} 
		$rpt="1$$".$rpt;
	}	

	return $rpt;
	
}

function fn_descarga_archivo($url,$nombre){
	// $_SERVER['DOCUMENT_ROOT']."/avante/Files/documentos/";
	$directorio=$GLOBALS["cte_ruta_fileserver_sunatNew"].date("Ym")."/";

	if (!file_exists($directorio)) {
    	mkdir($directorio, 0777, true);
	}
	//$nombre =substr($url,30,strlen($url));
	$ch = curl_init( $url );
	//Establecer un tiempo de espera
	curl_setopt( $ch, CURLOPT_TIMEOUT, 5 );
	curl_setopt( $ch, CURLOPT_CONNECTTIMEOUT, 5 );
	//establecer NOBODY en true para hacer una solicitud tipo HEAD
	curl_setopt( $ch, CURLOPT_NOBODY, true );
	//Permitir seguir redireccionamientos
	curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, true );
	//recibir la respuesta como string, no output
	curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
	$data = curl_exec( $ch );
	
	//Obtener el cdigo de respuesta
	$httpcode = curl_getinfo( $ch, CURLINFO_HTTP_CODE );
	//cerrar conexin
	curl_close( $ch );
	//Aceptar solo respuesta 200 (Ok), 301 (redireccin permanente) o 302 (redireccin temporal)
	$accepted_response = array( 200, 301, 302 );
	
	if( in_array( $httpcode, $accepted_response ) ) {
		//return true;
		$source = file_get_contents($url);
		$rs=file_put_contents($directorio.$nombre,$source);
		$nombre=$nombre;
	} else {
		$nombre="";
	} 
	return $nombre;
}

?>